// glslsandboxFractal75660_0Mod01.fsh
// https://glslsandbox.com/e#75660.0
// Original shader from: https://www.shadertoy.com/view/Nd3XzB

// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(time*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

#define iTime u_Elapsed* 0.314159
#define iResolution u_WindowSize
uniform sampler2D iChannel0;

#ifdef GL_ES
precision mediump float;
#endif

// glslsandbox uniforms
//uniform float time;
//uniform vec2 resolution;

// shadertoy emulation
//#define iTime time
//#define iResolution resolution

// --------[ Original ShaderToy begins here ]---------- //
#define PI acos(-1.0)
#define TAU PI*2.0
vec2 rotate(vec2 p, float a)
{
    return mat2(cos(a),sin(a),-sin(a),cos(a))*p;
}

vec3 rotate(vec3 p,vec3 axis,float theta)
{
    vec3 v = cross(axis,p), u = cross(v, axis);
    return u * cos(theta) + v * sin(theta) + axis * dot(p, axis);   
}

vec2 pmod(vec2 p, float r)
{
    float a = mod(atan(p.y, p.x), TAU / r) - 0.5 * TAU / r;
    return length(p) * vec2(-sin(a), cos(a));
}

vec3 hue(float t){
	return cos((vec3(0,2,-2)/3.+t)*TAU)*.5+.5;
}

float map(vec3 p)
{
    p.z -= iTime*3.;
    p = asin(sin(p/8.))*8.;
    p.xy = rotate(p.xy,iTime*0.08);
    p.yz = rotate(p.yz,iTime*0.1);
    for(int i=0;i<5;i++)
    {
        p.xy = pmod(p.xy,12.0);
        p.y-=4.0;
        p.yz = pmod(p.yz,16.0);
        p.z-=6.8;
    }
    return abs(dot(abs(p),rotate(normalize(vec3(2,1,3)),normalize(vec3(7,1,2)),1.8))-0.3);
}
void main( void )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   vec2 uv = (gl_FragCoord.xy * 2.0 - iResolution.xy) / iResolution.y;
 	vec3 ro=vec3(0,0,3.5);
 	vec3 ta = vec3(1,0,0);
 	ta.xz=rotate(ta.xz,iTime*0.2);
 	
 	vec3 w=normalize(ta-ro);
 	vec3 u=normalize(cross(w,vec3(0,1,0)));
    vec3 rd=mat3(u,cross(u,w),w)*normalize(vec3(uv,2));
    vec3 col = vec3(0);
    float d,t=5.0;
    for(float i=1.0;i>0.0;i-=1.0/80.0)
    {
     	t+=d=map(ro+t*rd);
        if(d<0.001)
        {
            col+=mix(vec3(1),hue(length(ro+t*rd)*0.1+iTime*0.1),0.6)*i*i;
            break;
        }
    }
    gl_FragColor = vec4(col, 1.0);
}
// --------[ Original ShaderToy ends here ]---------- //

//void main(void)
//{//
 //   mainImage(gl_FragColor, gl_FragCoord.xy);
//}//